<?php

/*
 * This file is part of the PHPBench package
 *
 * (c) Daniel Leech <daniel@dantleech.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 */

namespace PhpBench\Report;

use PhpBench\Dom\Document;
use PhpBench\Registry\Config;
use PhpBench\Registry\RegistrableInterface;
use PhpBench\Report\Model\Reports;

/**
 * Implementors render the DOM Document generated by a generator to some visual medium.
 *
 * This might be either direct output (e.g. to the console, streaming markup) or to a file.
 *
 * Example implementors might be XsltRenderer, ConsoleRenderer, etc
 */
interface RendererInterface extends RegistrableInterface
{
    /**
     * @return void
     */
    public function render(Reports $report, Config $config);
}
