<?php session_start();?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>SMS Admin| Add Result </title>
    <link rel="stylesheet" href="css/bootstrap.min.css" media="screen">
    <link rel="stylesheet" href="css/font-awesome.min.css" media="screen">
    <link rel="stylesheet" href="css/animate-css/animate.min.css" media="screen">
    <link rel="stylesheet" href="css/lobipanel/lobipanel.min.css" media="screen">
    <link rel="stylesheet" href="css/prism/prism.css" media="screen">
    <link rel="stylesheet" href="css/select2/select2.min.css">
    <link rel="stylesheet" href="css/main.css" media="screen">
    <script src="js/modernizr/modernizr.min.js"></script>
  


</head>

<body class="top-navbar-fixed">
    <div class="main-wrapper">

        <!-- ========== TOP NAVBAR ========== -->
        <?php include 'includes/topbar.php'; ?>
        <!-- ========== WRAPPER FOR BOTH SIDEBARS & MAIN CONTENT ========== -->
        <div class="content-wrapper">
            <div class="content-container">

                <!-- ========== LEFT SIDEBAR ========== -->
                <?php include 'includes/leftbar.php'; ?>
                <!-- /.left-sidebar -->

                <div class="main-page">

                    <div class="container-fluid">
                       
                        <!-- /.row -->
                    </div>
                    <div class="container-fluid">

<?php
// student-card.php

// --- Connexion DB ---
include "includes/pdo.php";

// --- Récupération étudiant ---
$studentId = isset($_GET['studentId']) ? (int)$_GET['studentId'] : 0;
if ($studentId <= 0) {
    echo "<p style='color:crimson'>Aucun étudiant sélectionné. Utilise ?studentId=ID</p>";
    exit;
}

$sql = "SELECT st.StudentId, st.StudentName, st.RollId, st.ClassId, c.ClassName
        FROM tblstudents st
        JOIN tblclasses c ON st.ClassId = c.id
        WHERE st.StudentId = :sid";
$stmt = $pdo->prepare($sql);
$stmt->execute(['sid' => $studentId]);
$student = $stmt->fetch();

if (!$student) {
    echo "<p style='color:crimson'>Étudiant introuvable (ID: ".htmlspecialchars($studentId).").</p>";
    exit;
}
$id=$student['StudentId'];
$hash=md5($student['StudentId']);
$sql2="INSERT INTO codes(StudentId,hash) VALUES (:id,:hash)";
$ss=$pdo->prepare($sql2);
$sse=$ss->execute([':id'=>$id,':hash'=>$hash]);
// --- URL du relevé ---
$transcriptUrl = "http://isskin-001-site1.ntempurl.com/student/notes.php?studentId=".$hash;

// --- Génération QR code en base64 ---
require __DIR__ . '/qrcode/vendor/autoload.php'; // besoin de composer require endroid/qr-code
use Endroid\QrCode\Builder\Builder;
use Endroid\QrCode\Writer\PngWriter;

$qr = Builder::create()
    ->writer(new PngWriter())
    ->data($transcriptUrl)
    ->size(160)
    ->margin(10)
    ->build();
$qrDataUri = $qr->getDataUri();

function h($v){ return htmlspecialchars((string)$v, ENT_QUOTES|ENT_SUBSTITUTE, 'UTF-8'); }
?>
<!DOCTYPE html>
<html lang="fr">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>Carte académique — <?= h($student['StudentName']) ?></title>
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;600;700&display=swap" rel="stylesheet">
<style>
:root{
  --primary:#0f172a;
  --muted:#6b7280;
  --bg:#f6f8fb;
  --card:#fff;
}
body{background:var(--bg); margin:0; font-family:Poppins, sans-serif; color:var(--primary);}
.container{display:flex; align-items:center; justify-content:center; min-height:100vh;}
.card{background:var(--card); border-radius:20px; box-shadow:0 12px 32px rgba(15,23,42,0.08); padding:40px; max-width:650px; width:100%; text-align:center; border:1px solid #e5e7eb;}
.logo{width:80px; height:80px; background:var(--primary); color:white; border-radius:50%; display:flex; align-items:center; justify-content:center; font-weight:700; font-size:20px; margin:0 auto 16px auto;}
h1{margin:8px 0; font-size:26px; font-weight:700;}
h2{margin:4px 0; font-size:18px; font-weight:600; color:var(--muted);}
.meta{margin:20px 0; display:grid; grid-template-columns:repeat(2,1fr); gap:20px;}
.block{background:#f9fafb; padding:14px; border-radius:12px; border:1px solid #e5e7eb;}
.block h4{margin:0; font-size:13px; color:var(--muted); font-weight:500;}
.block p{margin:4px 0 0 0; font-size:16px; font-weight:600;}
.qr{margin-top:28px;}
.qr img{width:160px; height:160px;}
.footer{margin-top:20px; font-size:13px; color:var(--muted);}
</style>
</head>
<body>
<div class="container" style="padding:50px">
  <div class="card">
    <div class="logo">LOGO</div>
    <h1><?= h($student['StudentName']) ?></h1>
    <h2>Carte académique</h2>

    <div class="meta">
      <div class="block">
        <h4>Matricule</h4>
        <p><?= h($student['RollId']) ?></p>
      </div>
      <div class="block">
        <h4>Classe</h4>
        <p><?= h($student['ClassName']) ?></p>
      </div>
      <div class="block">
        <h4>Année académique</h4>
        <p><?= date('Y')-1 . " / " . date('Y') ?></p>
      </div>
      <div class="block">
        <h4>ID interne</h4>
        <p>#<?= h($student['StudentId']) ?></p>
      </div>
    </div>

    <div class="qr">
      <img src="<?= $qrDataUri ?>" alt="QR Code vers relevé">
      <div class="footer">Scannez le QR code pour consulter le relevé électronique</div>
    </div>
  </div>
  <div class="qr">
  <img src="<?= $qrDataUri ?>" alt="QR Code vers relevé">
  <div class="footer">Scannez le QR code pour consulter le relevé électronique</div>
</div>

<button id="btnExport" style="margin-top:20px; padding:10px 20px; border:none; background:#0f172a; color:white; font-size:15px; border-radius:8px; cursor:pointer;">
  📥 Télécharger en PDF
</button>

</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.10.1/html2pdf.bundle.min.js"></script>
<script>
document.getElementById("btnExport").addEventListener("click", function() {
    const element = document.querySelector(".card");
    const opt = {
        margin:       0.5,
        filename:     "carte-<?= $student['StudentName'] ?>.pdf",
        image:        { type: 'jpeg', quality: 1 },
        html2canvas:  { scale: 2, useCORS: true },
        jsPDF:        { unit: 'in', format: 'A4', orientation: 'portrait' }
    };
    html2pdf().set(opt).from(element).save();
});
</script>

</div>
                </div>
                <!-- /.content-container -->
            </div>
            <!-- /.content-wrapper -->
        </div>
        <!-- /.main-wrapper -->
        <script src="js/jquery/jquery-2.2.4.min.js"></script>
        <script src="js/bootstrap/bootstrap.min.js"></script>
        <script src="js/pace/pace.min.js"></script>
        <script src="js/lobipanel/lobipanel.min.js"></script>
        <script src="js/iscroll/iscroll.js"></script>
        <script src="js/prism/prism.js"></script>
        <script src="js/select2/select2.min.js"></script>
        <script src="js/main.js"></script>
        <script>
            $(function($) {
                $(".js-states").select2();
                $(".js-states-limit").select2({
                    maximumSelectionLength: 2
                });
                $(".js-states-hide").select2({
                    minimumResultsForSearch: Infinity
                });
            });
        </script>

</body>
</html>
