<?php
// Connexion à la base
$pdo = new PDO("mysql:host=localhost;dbname=srms;charset=utf8", "root", "");

// Récupération des cours avec crédits
$sqlSubjects = "
    SELECT s.id, s.SubjectName, sc.credit, sc.ClassId
    FROM tblsubjectcombination sc
    JOIN tblsubjects s ON s.id = sc.SubjectId
    ORDER BY s.SubjectName
";
$stmt = $pdo->query($sqlSubjects);
$subjects = $stmt->fetchAll(PDO::FETCH_ASSOC);

$subjectMap = [];
foreach ($subjects as $sub) {
    $subjectMap[$sub['id']] = $sub;
}

// Récupération étudiants + notes
$sql = "
    SELECT st.StudentId, st.StudentName, st.RollId, st.ClassId, c.ClassName,
           r.SubjectId, r.marks
    FROM tblstudents st
    JOIN tblclasses c ON st.ClassId = c.id
    JOIN tblresult r ON r.StudentId = st.StudentId
    ORDER BY st.StudentName, r.SubjectId
";
$stmt = $pdo->query($sql);

$studentsData = [];
while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    $sid = $row['StudentId'];
    if (!isset($studentsData[$sid])) {
        $studentsData[$sid] = [
            'name' => $row['StudentName'],
            'roll' => $row['RollId'],
            'class' => $row['ClassName'],
            'marks' => [],
            'lightFails' => 0,
            'seriousFails' => 0,
            'creditsValidated' => 0,
            'creditsNotValidated' => 0,
            'totalPoints' => 0,
            'totalCredits' => 0,
            'average' => 0,
            'mention' => ''
        ];
    }

    $mark = (float)$row['marks'];
    $subjId = $row['SubjectId'];
    $credit = $subjectMap[$subjId]['credit'];

    $studentsData[$sid]['marks'][$subjId] = $mark;

    if ($mark < 8) $studentsData[$sid]['seriousFails']++;
    elseif ($mark < 10) $studentsData[$sid]['lightFails']++;

    if ($mark >= 10) {
        $studentsData[$sid]['creditsValidated'] += $credit;
    } else {
        $studentsData[$sid]['creditsNotValidated'] += $credit;
    }

    $studentsData[$sid]['totalPoints'] += $mark * $credit;
    $studentsData[$sid]['totalCredits'] += $credit;
}

// Calcul moyenne & mention
foreach ($studentsData as &$st) {
    if ($st['totalCredits'] > 0) {
        $st['average'] = $st['totalPoints'] / $st['totalCredits'];
    }
    $m = $st['average'];
    if ($m >= 16) $st['mention'] = "Très Bien";
    elseif ($m >= 14) $st['mention'] = "Bien";
    elseif ($m >= 12) $st['mention'] = "Assez Bien";
    elseif ($m >= 10) $st['mention'] = "Passable";
    else $st['mention'] = "Échec";
}
unset($st);
?>
<!DOCTYPE html>
<html lang="fr">
<head>
<meta charset="UTF-8">
<title>Grille de Délibération LMD</title>
<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<style>
table { border-collapse: collapse; width: 100%; font-size: 14px; }
th, td { border: 1px solid #999; padding: 4px; text-align: center; }
.hidden { display: none; }

/* Notes et moyenne colorées */
.note-valid { color: green; font-weight: bold; }
.note-invalid { color: red; font-weight: bold; }
</style>
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
</head>
<body>

<h2>Grille de Délibération - <?= htmlspecialchars(current($studentsData)['class'] ?? '') ?></h2>

<table id="gradesTable" class="display">
    <thead>
        <!-- Ligne 1 : noms des cours -->
        <tr>
            <th rowspan="2">Étudiant</th>
            <?php foreach ($subjects as $sub): ?>
                <th><?= htmlspecialchars($sub['SubjectName']) ?></th>
            <?php endforeach; ?>
            <th rowspan="2">Échecs légers</th>
            <th rowspan="2">Échecs graves</th>
            <th rowspan="2">Crédits validés</th>
            <th rowspan="2">Crédits non validés</th>
            <th rowspan="2">Moyenne</th>
            <th rowspan="2">Mention</th>
            <th rowspan="2" class="hidden">Classe</th>
        </tr>
        <!-- Ligne 2 : crédits -->
        <tr>
            <?php foreach ($subjects as $sub): ?>
                <th><?= htmlspecialchars($sub['credit']) ?></th>
            <?php endforeach; ?>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($studentsData as $st): ?>
            <tr>
                <td><?= htmlspecialchars($st['name']) ?></td>
                <?php foreach ($subjects as $sub): 
                    $mark = $st['marks'][$sub['id']] ?? '';
                    $class = ($mark !== '' && $mark >= 10) ? "note-valid" : "note-invalid";
                ?>
                    <td class="<?= $mark === '' ? '' : $class ?>">
                        <?= htmlspecialchars($mark) ?>
                    </td>
                <?php endforeach; ?>
                <td><?= $st['lightFails'] ?></td>
                <td><?= $st['seriousFails'] ?></td>
                <td><?= $st['creditsValidated'] ?></td>
                <td><?= $st['creditsNotValidated'] ?></td>
                <?php 
                    $avgClass = ($st['average'] >= 10) ? "note-valid" : "note-invalid";
                ?>
                <td class="<?= $avgClass ?>"><?= number_format($st['average'], 2) ?></td>
                <td><?= htmlspecialchars($st['mention']) ?></td>
                <td class="hidden"><?= htmlspecialchars($st['class']) ?></td>
            </tr>
        <?php endforeach; ?>
    </tbody>
</table>

<script>
$(document).ready(function() {
    $('#gradesTable').DataTable({
        "language": {
            "url": "//cdn.datatables.net/plug-ins/1.13.6/i18n/fr-FR.json"
        },
        paging: true,
        searching: true,
        ordering: true
    });
});
</script>
</body>
</html>
