<?php
// Connexion DB
include "pdo.php";

// Récupération liste des classes
$classes = $pdo->query("SELECT id, ClassName FROM tblclasses ORDER BY ClassName")->fetchAll(PDO::FETCH_ASSOC);

// Classe sélectionnée (via GET)
$selectedClass = isset($_GET['classid']) ? (int)$_GET['classid'] : 0;

$subjects = [];
$studentsData = [];

if ($selectedClass > 0) {
    // Matières de la classe
    $sqlSubjects = "
        SELECT DISTINCT s.id, s.SubjectName, sc.credit
        FROM tblsubjectcombination sc
        JOIN tblsubjects s ON s.id = sc.SubjectId
        WHERE sc.ClassId = :classId AND sc.ProfessorId > 0
        ORDER BY s.SubjectName
    ";
    $stmt = $pdo->prepare($sqlSubjects);
    $stmt->execute(['classId' => $selectedClass]);
    $subjects = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $subjectMap = [];
    foreach ($subjects as $sub) {
        $subjectMap[$sub['id']] = $sub;
    }

    // Étudiants + résultats
    $sql = "
        SELECT st.StudentId, st.StudentName, st.RollId, st.ClassId, c.ClassName,
               r.SubjectId, r.marks
        FROM tblstudents st
        JOIN tblclasses c ON st.ClassId = c.id
        LEFT JOIN tblresult r ON r.StudentId = st.StudentId
        WHERE st.ClassId = :classId
        ORDER BY st.StudentName, r.SubjectId
    ";
    $stmt = $pdo->prepare($sql);
    $stmt->execute(['classId' => $selectedClass]);

    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $sid = $row['StudentId'];
        if (!isset($studentsData[$sid])) {
            $studentsData[$sid] = [
                'name' => $row['StudentName'],
                'id' => $row['StudentId'],
                'roll' => $row['RollId'],
				'stid'=>$sid,
                'class' => $row['ClassName'],
                'marks' => [],
                'lightFails' => 0,
                'seriousFails' => 0,
                'creditsValidated' => 0,
                'creditsNotValidated' => 0,
                'totalPoints' => 0,
                'totalCredits' => 0,
                'average' => 0,
                'mention' => ''
            ];
        }

        if ($row['SubjectId']) {
            $mark = (float)$row['marks'];
            $subjId = $row['SubjectId'];
            $credit = $subjectMap[$subjId]['credit'];

            $studentsData[$sid]['marks'][$subjId] = $mark;

            if ($mark < 8) $studentsData[$sid]['seriousFails']++;
            elseif ($mark < 10) $studentsData[$sid]['lightFails']++;

            if ($mark >= 10) {
                $studentsData[$sid]['creditsValidated'] += $credit;
            } else {
                $studentsData[$sid]['creditsNotValidated'] += $credit;
            }

            $studentsData[$sid]['totalPoints'] += $mark * $credit;
            $studentsData[$sid]['totalCredits'] += $credit;
        }
    }

    // Moyenne & mention
    foreach ($studentsData as &$st) {
        if ($st['totalCredits'] > 0) {
            $st['average'] = $st['totalPoints'] / $st['totalCredits'];
        }
        $m = $st['average'];
        if ($m >= 16) $st['mention'] = "Très Bien";
        elseif ($m >= 14) $st['mention'] = "Bien";
        elseif ($m >= 12) $st['mention'] = "Assez Bien";
        elseif ($m >= 10) $st['mention'] = "Passable";
        else $st['mention'] = "Échec";
    }
    unset($st);
	

}
?>



<link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
<link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.4.1/css/buttons.dataTables.min.css">

<style>
body { font-family: Arial, sans-serif;  }
select { padding: 5px; margin-bottom: 15px; }

table { border-collapse: collapse; width: 100%; font-size: 14px; }
th, td { border: 1px solid #999; padding: 4px; text-align: center; }
.hidden { display: none; }

/* Notes et moyenne colorées */
.note-valid { color: green; font-weight: bold; }
.note-invalid { background: #ff0000; font-weight: bold; }
.missing{background: #ffff00; font-weight: bold;}
 th.vertical-rotate{
    position: relative;
    width: 48px;
    height: 140px;
    padding: 0;
    overflow: visible;
  }
  th.vertical-rotate > span{
    position: absolute;
    top: 50%; left: 50%;
    transform: translate(-50%, -50%) rotate(-90deg);
    transform-origin: center center;
    white-space: nowrap;
    line-height: 1;
  }

  /* Impression/PDF */
  @media print{
    th.vertical-rotate > span{
      transform: translate(-50%, -50%) rotate(-90deg);
    }
  }
  
</style>
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>





<!-- Sélecteur de classe -->
<form method="get" id="classForm">
    <label for="class">Choisir une classe :</label>
    <select name="class" id="class" onchange="document.getElementById('classForm').submit()">
        <option value="">-- Sélectionner --</option>
        <?php foreach ($classes as $cl): ?>
            <option value="<?= $cl['id'] ?>" <?= $cl['id']==$selectedClass ? 'selected' : '' ?>>
                <?= htmlspecialchars($cl['ClassName']) ?>
            </option>
        <?php endforeach; ?>
    </select>
</form>

<?php if ($selectedClass > 0): ?>
<table id="gradesTable" class="display">
    <thead>
        <tr>
            <th rowspan="2">Étudiant</th>
            <?php foreach ($subjects as $sub): ?>
                <th class="vertical-rotate" ><span><?= htmlspecialchars($sub['SubjectName']) ?></span></th>
            <?php endforeach; ?>
            <th rowspan="2" class="vertical-rotate" ><span>Échecs légers</span></th>
            <th rowspan="2" class="vertical-rotate" ><span>Échecs graves</span></th>
            <th rowspan="2" class="vertical-rotate" ><span>Crédits validés</span></th>
            <th rowspan="2" class="vertical-rotate" ><span>Crédits non validés</span></th>
            <th rowspan="2" class="vertical-rotate" ><span>Moyenne</span></th>
            <th rowspan="2" class="vertical-rotate" ><span>Mention</span></th>
        </tr>
        <tr>
            <?php foreach ($subjects as $sub): ?>
                <th><?= htmlspecialchars($sub['credit']) ?></th>
            <?php endforeach; ?>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($studentsData as $st): ?>
            <tr>
                <td><?= htmlspecialchars($st['name']) ?></td>
                <?php foreach ($subjects as $sub): 
                    $mark = $st['marks'][$sub['id']] ?? '';
                    $class = ($mark !== '' && $mark >= 10) ? "note-valid" : "note-invalid";
					
                ?>
                    <td class="<?= $mark === '' ? 'missing' : $class ?>">
                        <?= htmlspecialchars($mark) ?>
                    </td>
                <?php endforeach; ?>
                <td><?= $st['lightFails'] ?></td>
                <td><?= $st['seriousFails'] ?></td>
                <td><?= $st['creditsValidated'] ?></td>
                <td><?= $st['creditsNotValidated'] ?></td>
                <?php $avgClass = ($st['average'] >= 10) ? "note-valid" : "note-invalid"; ?>
                <td class="<?= $avgClass ?>"><?= number_format($st['average'], 2) ?></td>
                <td><?= htmlspecialchars($st['mention']) ?></td>
            </tr>
        <?php endforeach; ?>
    </tbody>
</table>
<?php else: ?>
<p><em>Veuillez choisir une classe pour afficher la grille.</em></p>
<?php endif; ?>

<script src="https://cdn.datatables.net/buttons/2.4.1/js/dataTables.buttons.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/pdfmake.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.2.7/vfs_fonts.js"></script>
<script src="https://cdn.datatables.net/buttons/2.4.1/js/buttons.html5.min.js"></script>


<script>
$(document).ready(function() {
    $('#gradesTable').DataTable({
        "language": { "url": "//cdn.datatables.net/plug-ins/1.13.6/i18n/fr-FR.json" },
        paging: true,
        searching: true,
        ordering: true,
		dom: 'lfrtip' 
        
    });
});
</script>


<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf-autotable/3.5.29/jspdf.plugin.autotable.min.js"></script>
<script>
document.getElementById("exportPDF").addEventListener("click", function () {
    const { jsPDF } = window.jspdf;
    const doc = new jsPDF('landscape', 'pt', 'a4');

    doc.text("Grille de Délibération - Système LMD", 40, 40);

    doc.autoTable({
        html: '#gradesTable',   // on prend directement ton tableau HTML
        startY: 60,
        theme: 'grid',
        styles: {
            fontSize: 8,
            halign: 'center',
            valign: 'middle'
        },
        headStyles: {
            fillColor: [200, 200, 200], // gris clair en-tête
            textColor: 0,
            fontStyle: 'bold'
        },
        didParseCell: function (data) {
            // Conserver les couleurs CSS des notes
            if (data.cell.raw.classList.contains("note-valid")) {
                data.cell.styles.textColor = [0, 128, 0]; // vert
                data.cell.styles.fontStyle = 'bold';
            }
            if (data.cell.raw.classList.contains("note-invalid")) {
                data.cell.styles.textColor = [200, 0, 0]; // rouge
                data.cell.styles.fontStyle = 'bold';
            }
        }
    });

    doc.save("grille_deliberation.pdf");
});
</script>

