<?php
session_start();
error_reporting(0);
include 'includes/config.php';
if (strlen($_SESSION['alogin']) == "") {
    header("Location: index.php");
} else {

    ?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Admin Manage Results</title>
    <link rel="stylesheet" href="css/bootstrap.min.css" media="screen">
    <link rel="stylesheet" href="css/font-awesome.min.css" media="screen">
    <link rel="stylesheet" href="css/animate-css/animate.min.css" media="screen">
    <link rel="stylesheet" href="css/lobipanel/lobipanel.min.css" media="screen">
    <link rel="stylesheet" href="css/prism/prism.css" media="screen"> <!-- USED FOR DEMO HELP - YOU CAN REMOVE IT -->
    <link rel="stylesheet" type="text/css" href="js/DataTables/datatables.min.css" />
    <link rel="stylesheet" href="css/main.css" media="screen">
	
	
	 <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <!-- DataTables JS -->
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

	
    <script src="js/modernizr/modernizr.min.js"></script>
    <style>
        .errorWrap {
            padding: 10px;
            margin: 0 0 20px 0;
            background: #fff;
            border-left: 4px solid #dd3d36;
            -webkit-box-shadow: 0 1px 1px 0 rgba(0, 0, 0, .1);
            box-shadow: 0 1px 1px 0 rgba(0, 0, 0, .1);
        }

        .succWrap {
            padding: 10px;
            margin: 0 0 20px 0;
            background: #fff;
            border-left: 4px solid #5cb85c;
            -webkit-box-shadow: 0 1px 1px 0 rgba(0, 0, 0, .1);
            box-shadow: 0 1px 1px 0 rgba(0, 0, 0, .1);
        }
    </style>
</head>

<body class="top-navbar-fixed">
    <div class="main-wrapper">

        <!-- ========== TOP NAVBAR ========== -->
        <?php include 'includes/topbar.php';?>
        <!-- ========== WRAPPER FOR BOTH SIDEBARS & MAIN CONTENT ========== -->
        <div class="content-wrapper">
            <div class="content-container">
                <?php include 'includes/leftbar.php';?>

                <div class="main-page" style="background:#fff;padding-left:60px!important">
                    <div class="container-fluid" >
                        <div class="row page-title-div">
                            <div class="col-md-6">
                                <h2>Grille de Délibération - Système LMD</h2>

                            </div>

                            <!-- /.col-md-6 text-right -->
                        </div>
                        <!-- /.row -->
                        <div class="row breadcrumb-div">
                            <div class="col-md-6">
                                <ul class="breadcrumb">
                                    <li><a href="dashboard.php"><i class="fa fa-home"></i> Home</a></li>
                                    <li> Students</li>
                                    <li class="active">Manage Students</li>
                                    <li style="float:right;display:inline-block">
									<button class="btn btn-ok" style="color:#fefefe;background:#00A000"id="exportPDF">📄 Exporter en PDF</button>
									<button id="exportExcel">📊 Exporter en Excel</button>
									</li>
                                
								</ul>
                            </div>

                        </div>
                        <!-- /.row -->
                    </div>
                    <!-- /.container-fluid -->

                    <section class="section">
                        <div class="container-fluid">


    <?php include 'includes/grille2.php';
	

	?>

<script>
// On normalise les clés côté JS
const subjects = <?= json_encode(array_map(function($s){
  return ['id'=>(int)$s['id'], 'name'=>$s['SubjectName'], 'credit'=>(float)$s['credit']];
}, $subjects), JSON_UNESCAPED_UNICODE) ?>;

const studentsData = <?= json_encode(array_values(array_map(function($st){
  return ['id'=>$st['id'],'name'=>$st['name'], 'marksBySubjectId'=>$st['marks']]; // marks = objet {subjectId: note}
}, $studentsData)), JSON_UNESCAPED_UNICODE) ?>;
</script>

    </div>
    <!-- /.container-fluid -->
    </section>
    <!-- /.section -->

    </div>
    <!-- /.main-page -->



    </div>
    <!-- /.content-container -->
    </div>
    <!-- /.content-wrapper -->

    </div>
    <!-- /.main-wrapper -->

    <!-- ========== COMMON JS FILES ========== -->
    <script src="js/jquery/jquery-2.2.4.min.js"></script>
    <script src="js/bootstrap/bootstrap.min.js"></script>
    <script src="js/pace/pace.min.js"></script>
    <script src="js/lobipanel/lobipanel.min.js"></script>
    <script src="js/iscroll/iscroll.js"></script>

    <!-- ========== PAGE JS FILES ========== -->
    <script src="js/prism/prism.js"></script>
    <script src="js/DataTables/datatables.min.js"></script>

    <!-- ========== THEME JS ========== -->
    <script src="js/main.js"></script>
	<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>

    <script>
        $(function ($) {
            $('#example').DataTable();

            $('#example2').DataTable({
                "scrollY": "300px",
                "scrollCollapse": true,
                "paging": false
            });
			/*

            $('#example2').DataTable();
					
					document.getElementById("exportExcel").addEventListener("click", function () {
				let table = document.getElementById("gradesTable");
				let wb = XLSX.utils.table_to_book(table, { sheet: "Grille LMD" });

				// Sauvegarde du fichier
				XLSX.writeFile(wb, "grille_deliberation.xlsx");
			});
			*/
        });
    </script>
	
	<script>
	/*
// Convertit un index de colonne (1=A) en lettre Excel (A, B, ..., Z, AA, AB, ...)
function colLetter(n){
  let s="";
  while(n>0){ let m=(n-1)%26; s=String.fromCharCode(65+m)+s; n=Math.floor((n-1)/26); }
  return s;
}

document.getElementById("exportExcel").addEventListener("click", function () {
  // 0) Sécurité: s'assurer que c'est bien des tableaux
  const subs = Array.isArray(subjects) ? subjects : Object.values(subjects || {});
  const studs = Array.isArray(studentsData) ? studentsData : Object.values(studentsData || {});

  let wb = XLSX.utils.book_new();
  let ws_data = [];

  // 1) En-tête 1 : noms de colonnes (Étudiant + noms de cours + colonnes calculées)
  const computedCols = ["Échecs légers","Échecs graves","Crédits validés","Crédits non validés","Moyenne","Mention"];
  let header1 = ["Étudiant", ...subs.map(s => s.name), ...computedCols];
  ws_data.push(header1);

  // 2) En-tête 2 : crédits sous chaque cours
  let header2 = ["" , ...subs.map(s => s.credit), ...Array(computedCols.length).fill("")];
  ws_data.push(header2);

  // Quelques repères de colonnes (1-based)
  const colStudent = 1;
  const colFirstCourse = colStudent + 1;                  // B
  const colLastCourse  = colFirstCourse + subs.length - 1;// dépend du nb de cours
  const colLightFails  = colLastCourse + 1;
  const colSerious     = colLightFails + 1;
  const colCredOK      = colSerious + 1;
  const colCredKO      = colCredOK + 1;
  const colAvg         = colCredKO + 1;
  const colMention     = colAvg + 1;

  const courseRangeRow2 = `$${colLetter(colFirstCourse)}$2:$${colLetter(colLastCourse)}$2`; // ligne crédits

  // 3) Lignes étudiants
  let excelRow = 3; // car 1 = en-tête 1, 2 = en-tête crédits
  studs.forEach(stu => {
    // On reconstruit les notes dans l'ordre des matières
    const marksRow = subs.map(s => {
      const val = stu.marksBySubjectId ? stu.marksBySubjectId[String(s.id)] ?? stu.marksBySubjectId[s.id] : "";
      return (val === "" || val === null || typeof val === "undefined") ? "" : Number(val);
    });

    const row = [stu.name, ...marksRow];

    // Plages utiles pour les formules (ex: B3:K3)
    const rowRange = `${colLetter(colFirstCourse)}${excelRow}:${colLetter(colLastCourse)}${excelRow}`;

    // 3.a Échecs légers (8 ou 9)
    row[colLightFails-1] = { f: `COUNTIF(${rowRange},8)+COUNTIF(${rowRange},9)` };

    // 3.b Échecs graves (<8)
    row[colSerious-1] = { f: `COUNTIF(${rowRange},"<8")` };

    // 3.c Crédits validés (note >=10)
    row[colCredOK-1] = { f: `SUMPRODUCT(--(${rowRange}>=10),${courseRangeRow2})` };

    // 3.d Crédits non validés (note <10)
    row[colCredKO-1] = { f: `SUMPRODUCT(--(${rowRange}<10),${courseRangeRow2})` };

    // 3.e Moyenne pondérée par crédits (avec protection /0)
    row[colAvg-1] = { f: `IF(SUM(${courseRangeRow2})=0,"",SUMPRODUCT(${rowRange},${courseRangeRow2})/SUM(${courseRangeRow2}))` };

    // 3.f Mention basée sur la moyenne
    const avgCell = `${colLetter(colAvg)}${excelRow}`;
    row[colMention-1] = { f: `IF(${avgCell}>=16,"Très Bien",IF(${avgCell}>=14,"Bien",IF(${avgCell}>=12,"Assez Bien",IF(${avgCell}>=10,"Passable","Échec"))))` };

    ws_data.push(row);
    excelRow++;
  });

  // 4) Création de la feuille + options (largeur colonnes basique)
  const ws = XLSX.utils.aoa_to_sheet(ws_data);
  ws["!cols"] = [
    { wch: 24 },                     // Étudiant
    ...subs.map(_ => ({ wch: 8 })),  // cours
    { wch: 12 },{ wch: 12 },{ wch: 14 },{ wch: 16 },{ wch: 10 },{ wch: 12 } // colonnes calculées
  ];
  XLSX.utils.book_append_sheet(wb, ws, "Grille LMD");

  // 5) Sauvegarde
  XLSX.writeFile(wb, "grille_deliberation_intelligente.xlsx");
});
*/


// Convertir un numéro de colonne (1=A, 2=B, etc.)
// Fonction utilitaire : convertit un numéro de colonne → lettre Excel
function colLetter(colNum) {
    let temp = "";
    let letter = "";
    while (colNum > 0) {
        temp = (colNum - 1) % 26;
        letter = String.fromCharCode(temp + 65) + letter;
        colNum = (colNum - temp - 1) / 26;
    }
    return letter;
}

document.getElementById("exportExcel").addEventListener("click", function () {
    const subs = Array.isArray(subjects) ? subjects : Object.values(subjects || {});
    const studs = Array.isArray(studentsData) ? studentsData : Object.values(studentsData || {});

    let wb = XLSX.utils.book_new();
    let ws_data = [];

    // Ligne 1 : en-têtes (noms cours)
    let header1 = ["StudentId", "Étudiant", ...subs.map(s => s.name), "Échecs légers", "Échecs graves", "Crédits validés", "Crédits non validés", "Moyenne", "Mention"];
    ws_data.push(header1);

    // Ligne 2 : crédits
    let header2 = ["", "", ...subs.map(s => s.credit || 0), "", "", "", "", "", ""];
    ws_data.push(header2);

    // Ligne 3 : SubjectId (sera masquée)
    let header3 = ["", "", ...subs.map(s => s.id || ""), "", "", "", "", "", ""];
    ws_data.push(header3);

    // Colonnes calculées (repères)
    const baseCol = 3; // colonne C = premier cours
    const lastCol = baseCol + subs.length - 1;
    const colLight = lastCol + 1;
    const colSerious = colLight + 1;
    const colCredOK = colSerious + 1;
    const colCredKO = colCredOK + 1;
    const colAvg = colCredKO + 1;
    const colMention = colAvg + 1;

    // Étudiants (notes à partir de ligne 4)
    let excelRow = 4;
    studs.forEach(stu => {
        const marksRow = subs.map(s => {
            let val = "";
            if (stu.marksBySubjectId) {
                val = stu.marksBySubjectId[String(s.id)] ?? stu.marksBySubjectId[s.id] ?? "";
            }
            return (val === "" || val === null || isNaN(val)) ? "" : Number(val);
        });

        let row = [stu.id || "", stu.name || "", ...marksRow];

        if (subs.length > 0) {
            let rowRange = `${colLetter(baseCol)}${excelRow}:${colLetter(lastCol)}${excelRow}`;
            let courseRangeRow2 = `$${colLetter(baseCol)}$2:$${colLetter(lastCol)}$2`;
            const avgCell = `${colLetter(colAvg)}${excelRow}`;

            row[colLight - 1]  = { f: `COUNTIF(${rowRange},8)+COUNTIF(${rowRange},9)` };
            row[colSerious - 1] = { f: `COUNTIF(${rowRange},"<8")` };
            row[colCredOK - 1]  = { f: `SUMPRODUCT(--(${rowRange}>=10),${courseRangeRow2})` };
            row[colCredKO - 1]  = { f: `SUMPRODUCT(--(${rowRange}<10),${courseRangeRow2})` };
            row[colAvg - 1]     = { f: `IF(SUM(${courseRangeRow2})=0,"",SUMPRODUCT(${rowRange},${courseRangeRow2})/SUM(${courseRangeRow2}))` };
            row[colMention - 1] = { f: `IF(${avgCell}>=16,"Très Bien",IF(${avgCell}>=14,"Bien",IF(${avgCell}>=12,"Assez Bien",IF(${avgCell}>=10,"Passable","Échec"))))` };
        } else {
            row[colLight - 1] = row[colSerious - 1] = row[colCredOK - 1] = row[colCredKO - 1] = row[colAvg - 1] = row[colMention - 1] = "";
        }

        ws_data.push(row);
        excelRow++;
    });

    // Génération de la feuille
    const ws = XLSX.utils.aoa_to_sheet(ws_data);

    // Largeur colonnes + cacher StudentId
    ws["!cols"] = [{ hidden: true }, { wch: 20 }, ...subs.map(_ => ({ wch: 8 })), {wch:12},{wch:12},{wch:14},{wch:16},{wch:10},{wch:12}];

    // Masquer ligne 3 (SubjectId)
    ws["!rows"] = [];
    ws["!rows"][2] = { hidden: true };

    XLSX.utils.book_append_sheet(wb, ws, "Grille LMD");

    // Sauvegarde fichier
    XLSX.writeFile(wb, "grille_deliberation_ids.xlsx");
});




</script>
</body>

</html>
<?php }?>