<?php
// Connexion à la base de données
$mysqli = new mysqli("localhost", "utilisateur", "motdepasse", "nom_base");
if ($mysqli->connect_error) {
    die("Connexion échouée : " . $mysqli->connect_error);
}

// Récupération des classes (pour le filtre)
$classesResult = $mysqli->query("SELECT DISTINCT tblclasses.id, tblclasses.ClassName 
    FROM tblclasses 
    JOIN tblstudents ON tblstudents.ClassId = tblclasses.id 
    JOIN tblsubjectcombination ON tblsubjectcombination.ClassId = tblclasses.id 
    WHERE tblsubjectcombination.ProfessorId = 2 
    ORDER BY tblclasses.ClassName");

$classes = [];
while ($row = $classesResult->fetch_assoc()) {
    $classes[$row['id']] = $row['ClassName'];
}

// Requête principale
$sql = "SELECT tblstudents.StudentName, tblsubjects.SubjectName, tblstudents.RollId, tblstudents.ClassId, tblclasses.ClassName, tblresult.marks 
        FROM tblresult 
        JOIN tblstudents ON tblstudents.StudentId = tblresult.StudentId 
        JOIN tblclasses ON tblstudents.ClassId = tblclasses.id 
        JOIN tblsubjectcombination ON tblsubjectcombination.ClassId = tblclasses.id AND tblsubjectcombination.SubjectId = tblresult.SubjectId 
        JOIN tblsubjects ON tblsubjects.id = tblsubjectcombination.SubjectId 
        WHERE tblsubjectcombination.ProfessorId = 2 
        ORDER BY tblstudents.StudentName, tblsubjects.SubjectName";

$result = $mysqli->query($sql);

$students = [];
$subjects = [];

// Organisation des données
while ($row = $result->fetch_assoc()) {
    $studentKey = $row['StudentName'] . " (ID: " . $row['RollId'] . ")";
    $subject = $row['SubjectName'];
    $subjects[$subject] = true;
    $students[$studentKey]['marks'][$subject] = $row['marks'];
    $students[$studentKey]['class'] = $row['ClassName'];
}

$subjects = array_keys($subjects);

// Fonction pour calculer la mention
function getMention($average) {
    if ($average < 8) return "Échec grave (Ajourné)";
    if ($average < 10) return "Ajourné";
    if ($average < 12) return "Passable";
    if ($average < 14) return "Assez bien";
    if ($average < 16) return "Bien";
    if ($average < 18) return "Très bien";
    return "Excellent";
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Grille de Délibération - Système LMD</title>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
    <style>
        .hidden { display: none; }
    </style>
	
	
	
	 <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Admin Manage Results</title>
    <link rel="stylesheet" href="css/bootstrap.min.css" media="screen">
    <link rel="stylesheet" href="css/font-awesome.min.css" media="screen">
    <link rel="stylesheet" href="css/animate-css/animate.min.css" media="screen">
    <link rel="stylesheet" href="css/lobipanel/lobipanel.min.css" media="screen">
    <link rel="stylesheet" href="css/prism/prism.css" media="screen"> <!-- USED FOR DEMO HELP - YOU CAN REMOVE IT -->
    <link rel="stylesheet" type="text/css" href="js/DataTables/datatables.min.css" />
    <link rel="stylesheet" href="css/main.css" media="screen">
	
	
	 <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/jquery.dataTables.min.css">
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
    <!-- DataTables JS -->
    <script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>

	
    <script src="js/modernizr/modernizr.min.js"></script>
    <style>
        .errorWrap {
            padding: 10px;
            margin: 0 0 20px 0;
            background: #fff;
            border-left: 4px solid #dd3d36;
            -webkit-box-shadow: 0 1px 1px 0 rgba(0, 0, 0, .1);
            box-shadow: 0 1px 1px 0 rgba(0, 0, 0, .1);
        }

        .succWrap {
            padding: 10px;
            margin: 0 0 20px 0;
            background: #fff;
            border-left: 4px solid #5cb85c;
            -webkit-box-shadow: 0 1px 1px 0 rgba(0, 0, 0, .1);
            box-shadow: 0 1px 1px 0 rgba(0, 0, 0, .1);
        }
    </style>
</head>
<body>

<h2>Grille de Délibération (LMD)</h2>

<div class="filter-container" style="margin-bottom: 10px;">
    <label for="classFilter">Filtrer par classe : </label>
    <select id="classFilter">
        <option value="">Toutes les classes</option>
        <?php foreach ($classes as $id => $className): ?>
            <option value="<?= htmlspecialchars($className) ?>"><?= htmlspecialchars($className) ?></option>
        <?php endforeach; ?>
    </select>
</div>

<table id="gradesTable" class="display" style="width:100%">
    <thead>
        <tr>
            <th>Élève</th>
            <?php foreach ($subjects as $subject): ?>
                <th><?= htmlspecialchars($subject) ?></th>
            <?php endforeach; ?>
            <th>Échecs légers</th>
            <th>Échecs graves</th>
            <th>Moyenne</th>
            <th>Mention</th>
            <th class="hidden">Classe</th>
        </tr>
    </thead>
    <tbody>
        <?php foreach ($students as $studentName => $data): 
            $marks = $data['marks'];
            $sum = 0; $count = 0; $failsLight = 0; $failsSevere = 0;
            foreach ($marks as $m) {
                $sum += $m; $count++;
                if ($m >= 8 && $m < 10) $failsLight++;
                if ($m < 8) $failsSevere++;
            }
            $average = $count > 0 ? round($sum / $count, 2) : 0;
            $mention = getMention($average);
        ?>
            <tr>
                <td><?= htmlspecialchars($studentName) ?></td>
                <?php foreach ($subjects as $subject): ?>
                    <td style="text-align:center">
                        <?= isset($marks[$subject]) ? htmlspecialchars($marks[$subject]) : "-" ?>
                    </td>
                <?php endforeach; ?>
                <td style="text-align:center"><?= $failsLight ?></td>
                <td style="text-align:center"><?= $failsSevere ?></td>
                <td style="text-align:center"><?= $average ?></td>
                <td><?= $mention ?></td>
                <td class="hidden"><?= htmlspecialchars($data['class']) ?></td>
            </tr>
        <?php endforeach; ?>
    </tbody>
</table>

<script>
$(document).ready(function() {
    var table = $('#gradesTable').DataTable({
        "language": { "url": "//cdn.datatables.net/plug-ins/1.13.6/i18n/fr-FR.json" },
        "paging": true,
        "searching": true,
        "ordering": true,
        "columnDefs": [
            { "targets": -1, "visible": false } // Colonne "Classe" masquée
        ]
    });

    // Détection auto de la colonne classe
    var classColumnIndex = $('#gradesTable thead th').length - 1;

    // Filtrage par classe
    $('#classFilter').on('change', function () {
        var selectedClass = $(this).val();
        table.column(classColumnIndex).search(selectedClass).draw();
    });
});
</script>

</body>
</html>

<?php $mysqli->close(); ?>
