<?php
// student-transcript.php
// Remplace les paramètres de connexion DB ci-dessous

$dbUser = "root";
$dbPass = "";
include "includes/pdo.php";


// Récupérer studentId depuis GET
$studentId = isset($_GET['studentId']) ? $_GET['studentId'] : 0;
$hash = isset($_GET['studentId']) ? $_GET['studentId'] : 0;




// Requête préparée
// Requête préparée
$sql = "SELECT studentId FROM codes WHERE hash = :hash LIMIT 1";
$stmt = $pdo->prepare($sql);
$stmt->execute(['hash' => $hash]);

$code = $stmt->fetch(); // peut être false si rien trouvé

if ($code && isset($code['studentId'])) {
    $studentId = $code['studentId'];
   // echo "✅ Student ID trouvé : " . $studentId;
} else {
    echo "❌ Code invalide ou inexistant.";
}
	
	
// 1) Récupérer infos étudiant + classe
$sql = "SELECT st.StudentId, st.StudentName, st.RollId, st.ClassId, c.ClassName
        FROM tblstudents st
        JOIN tblclasses c ON st.ClassId = c.id
        WHERE st.StudentId = :sid";
$stmt = $pdo->prepare($sql);
$stmt->execute(['sid' => $studentId]);
$student = $stmt->fetch();
if (!$student) {
    echo "<p style='color:crimson'>Étudiant introuvable (ID: ".htmlspecialchars($studentId).").</p>";
    exit;
}

// 2) Récupérer cours + crédits pour la classe (ordre affichage) et mapping subject id -> data
$sqlSubjects = "SELECT s.id AS SubjectId, s.SubjectName, sc.credit
                FROM tblsubjectcombination sc
                JOIN tblsubjects s ON s.id = sc.SubjectId
                WHERE sc.ClassId = :classId AND sc.ProfessorId > 0
                ORDER BY s.SubjectName";
$stmt = $pdo->prepare($sqlSubjects);
$stmt->execute(['classId' => $student['ClassId']]);
$subjects = $stmt->fetchAll();
if (!$subjects) $subjects = [];

// 3) Récupérer résultats de l'étudiant (par SubjectId)
$sqlResults = "SELECT SubjectId, marks FROM tblresult WHERE StudentId = :sid";
$stmt = $pdo->prepare($sqlResults);
$stmt->execute(['sid' => $studentId]);
$resultsRows = $stmt->fetchAll();
$resultsMap = [];
foreach ($resultsRows as $r) {
    $resultsMap[(int)$r['SubjectId']] = is_numeric($r['marks']) ? (float)$r['marks'] : null;
}

// 4) Calculs : échecs légers/graves, crédits validés/non validés, moyenne pondérée
$lightFails = 0; $seriousFails = 0;
$creditsValidated = 0; $creditsNotValidated = 0;
$totalPoints = 0; $totalCredits = 0;

foreach ($subjects as $s) {
    $sid = (int)$s['SubjectId'];
    $mark = isset($resultsMap[$sid]) ? $resultsMap[$sid] : null;
    $credit = isset($s['credit']) ? (float)$s['credit'] : 0;

    if ($mark !== null && $mark !== "") {
        if ($mark < 8) $seriousFails++;
        elseif ($mark < 10) $lightFails++;

        if ($mark >= 10) $creditsValidated += $credit;
        else $creditsNotValidated += $credit;

        $totalPoints += $mark * $credit;
        $totalCredits += $credit;
    }
}

$average = $totalCredits > 0 ? round($totalPoints / $totalCredits, 2) : 0.00;
// Mention selon barème
if ($average >= 16) $mention = "Très Bien";
elseif ($average >= 14) $mention = "Bien";
elseif ($average >= 12) $mention = "Assez Bien";
elseif ($average >= 10) $mention = "Passable";
else $mention = "Échec";

// Helper escape
function h($v){ return htmlspecialchars((string)$v, ENT_QUOTES|ENT_SUBSTITUTE, 'UTF-8'); }
?>
<!DOCTYPE html>
<html lang="fr">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>Relevé des cotes — <?= h($student['StudentName']) ?></title>

<!-- Google font -->
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600;700&display=swap" rel="stylesheet">

<style>
:root{
  --bg:#f6f8fb; --card:#ffffff; --muted:#6b7280; --accent:#0f172a;
  --green:#107f3e; --red:#c53030;
  --border:#e6e9ef;
}
*{box-sizing:border-box;font-family:Inter, system-ui, -apple-system, "Segoe UI", Roboto, "Helvetica Neue", Arial;}
body{background:var(--bg); margin:24px; color:var(--accent);}
.container{max-width:900px; margin:0 auto;}
.card{background:var(--card); border-radius:10px; box-shadow:0 6px 20px rgba(15,23,42,0.06); padding:20px; border:1px solid var(--border);}
.header{display:flex; align-items:center; gap:16px; margin-bottom:18px;}
.logo{width:84px; height:84px; background:#0f172a; color:white; display:flex; align-items:center; justify-content:center; font-weight:700; border-radius:8px;}
.univ{font-size:18px; font-weight:700;}
.sub{color:var(--muted); font-size:13px;}
.meta{display:flex; gap:14px; margin-top:8px; align-items:center;}
.student-info{display:flex; justify-content:space-between; gap:12px; margin-bottom:14px;}
.info-block{background:#fbfdff; padding:12px; border-radius:8px; border:1px solid var(--border); flex:1;}
.info-block h4{margin:0 0 6px 0; font-size:13px; color:var(--muted);}
.info-block p{margin:0; font-weight:600; font-size:15px;}

.table-wrap{overflow:auto; border-radius:8px; border:1px solid var(--border);}
table.transcript{width:100%; border-collapse:collapse; min-width:780px;}
table.transcript thead th{background:#f3f6fb; padding:10px; text-align:center; font-weight:700; border-bottom:1px solid var(--border);}
table.transcript thead .credit-row th{background:#ffffff; font-weight:600; font-size:13px; color:var(--muted);}
table.transcript th, table.transcript td{padding:10px; border-right:1px solid #f1f4f8;}
table.transcript td{background:white; font-size:14px; text-align:center;}
table.transcript tr td:first-child, table.transcript tr th:first-child { text-align:left; padding-left:14px; border-right:1px solid var(--border); width:240px; }
.course-name{font-weight:600; color:#0b2545;}
.note-valid{color:var(--green); font-weight:700;}
.note-invalid{color:var(--red); font-weight:700;}
.summary{display:flex; gap:12px; margin-top:14px; align-items:stretch;}
.summary .card { flex:1; padding:12px; text-align:center; }
.summary .big { font-size:20px; font-weight:700; margin-top:6px; }
.btns{display:flex; gap:8px; margin-top:16px; align-items:center;}
.btn{background:#0f172a; color:white; border:none; padding:10px 12px; border-radius:8px; cursor:pointer; font-weight:600;}
.btn.secondary{background:#fff; color:#0f172a; border:1px solid var(--border);}
.small-muted{font-size:13px; color:var(--muted);}
.footer-note{margin-top:18px; font-size:13px; color:var(--muted);}
@media print {
  body{background:white;}
  .btns{display:none;}
}
</style>
</head>
<body>
<div class="container">
  <div class="card" id="printable">
    <div class="header">
      <div class="logo">LOGO</div>
      <div style="flex:1;">
        <div class="univ">Université / Institut - Faculté / Département</div>
        <div class="sub">Relevé des cotes — Année universitaire <?= date('Y')-1 . ' / ' . date('Y') ?></div>
        <div class="meta small-muted">Classe : <?= h($student['ClassName']) ?> • Matricule : <?= h($student['RollId']) ?></div>
      </div>
      <div style="text-align:right;">
        <div class="small-muted">Date d'édition</div>
        <div style="font-weight:700"><?= date('d M Y') ?></div>
      </div>
    </div>

    <div class="student-info">
      <div class="info-block">
        <h4>Étudiant</h4>
        <p><?= h($student['StudentName']) ?></p>
      </div>
      <div class="info-block">
        <h4>Matricule</h4>
        <p><?= h($student['RollId']) ?></p>
      </div>
      <div class="info-block">
        <h4>Classe</h4>
        <p><?= h($student['ClassName']) ?></p>
      </div>
    </div>

    <div class="table-wrap">
        <table>
    <tr>
      <th>Élément</th>
      <th>Valeur</th>
    </tr>

    <?php foreach ($resultsMap as $row): ?>
      <tr><td><strong>Matière</strong></td><td><?= $row["SubjectName"] ?></td></tr>
      <tr><td><strong>Note /20</strong></td>
          <td class="<?= ($row['marks'] >= 10 ? 'pass' : 'fail') ?>">
            <?= $row["marks"] ?>
          </td></tr>
      <tr><td><strong>Crédits</strong></td><td><?= $row["credit"] ?></td></tr>
      <tr><td><strong>Validation</strong></td><td><?= ($row["marks"] >= 10 ? "Validé" : "Échec") ?></td></tr>
      <tr><td colspan="2" style="background:#f1f5f9;height:5px;"></td></tr>
    <?php endforeach; ?>
  </table>

  <div class="summary">
    <p><strong>Moyenne :</strong> <?= $average ?>/20</p>
    <p><strong>Crédits validés :</strong> <?= $creditsValid ?></p>
    <p><strong>Crédits non validés :</strong> <?= $creditsInvalid ?></p>
    <p><strong>Mention :</strong> <?= $mention ?></p>
  </div>
    </div>

    <div class="summary">
      <div class="card">
        <div class="small-muted">Crédits validés</div>
        <div class="big"><?= $creditsValidated ?></div>
      </div>
      <div class="card">
        <div class="small-muted">Crédits non validés</div>
        <div class="big"><?= $creditsNotValidated ?></div>
      </div>
      <div class="card">
        <div class="small-muted">Nombre échecs légers</div>
        <div class="big"><?= $lightFails ?></div>
      </div>
      <div class="card">
        <div class="small-muted">Nombre échecs graves</div>
        <div class="big"><?= $seriousFails ?></div>
      </div>
    </div>

    <div class="btns">
      <button class="btn" id="exportPdfBtn">📄 Exporter en PDF</button>
      <button class="btn secondary" id="printBtn">🖨️ Imprimer</button>
      <div style="flex:1"></div>
      <div class="small-muted">Format : paysage recommandé pour larges tableaux</div>
    </div>

    <div class="footer-note">
      <strong>Remarque :</strong> Les notes affichées ici proviennent de la base de données et la moyenne est calculée en pondérant par les crédits. Pour modifier les notes, exportez l'Excel intelligent, modifiez puis réimportez via la page d'administration.
    </div>
  </div>
</div>

<!-- html2pdf (capture DOM -> PDF fidèle au CSS) -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.9.3/html2pdf.bundle.min.js"></script>
<script>
document.getElementById('printBtn').addEventListener('click', function(){
  window.print();
});

document.getElementById('exportPdfBtn').addEventListener('click', function(){
  const element = document.getElementById('printable');

  // options : paysage, marges, filename
  const opt = {
    margin:       [10,10,10,10],
    filename:     'releve_cotes_<?= h($student['StudentId']) ?>.pdf',
    image:        { type: 'jpeg', quality: 0.98 },
    html2canvas:  { scale: 2, useCORS: true },
    jsPDF:        { unit: 'pt', format: 'a4', orientation: 'landscape' }
  };

  // générer le PDF — retourne une Promise
  html2pdf().set(opt).from(element).save();
});
</script>
</body>
</html>
