<?php
session_start();
error_reporting(0);
include 'includes/config.php';
if (strlen($_SESSION['alogin']) == "") {
    header("Location: index.php");
} else {

    ?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Admin Manage Students</title>
    <link rel="stylesheet" href="css/bootstrap.min.css" media="screen">
    <link rel="stylesheet" href="css/font-awesome.min.css" media="screen">
    <link rel="stylesheet" href="css/animate-css/animate.min.css" media="screen">
    <link rel="stylesheet" href="css/lobipanel/lobipanel.min.css" media="screen">
    <link rel="stylesheet" href="css/prism/prism.css" media="screen"> <!-- USED FOR DEMO HELP - YOU CAN REMOVE IT -->
    <link rel="stylesheet" type="text/css" href="js/DataTables/datatables.min.css" />
    <link rel="stylesheet" href="css/main.css" media="screen">
    <script src="js/modernizr/modernizr.min.js"></script>
    <style>
        .errorWrap {
            padding: 10px;
            margin: 0 0 20px 0;
            background: #fff;
            border-left: 4px solid #dd3d36;
            -webkit-box-shadow: 0 1px 1px 0 rgba(0, 0, 0, .1);
            box-shadow: 0 1px 1px 0 rgba(0, 0, 0, .1);
        }

        .succWrap {
            padding: 10px;
            margin: 0 0 20px 0;
            background: #fff;
            border-left: 4px solid #5cb85c;
            -webkit-box-shadow: 0 1px 1px 0 rgba(0, 0, 0, .1);
            box-shadow: 0 1px 1px 0 rgba(0, 0, 0, .1);
        }
    </style>
</head>

<body class="top-navbar-fixed">
    <div class="main-wrapper">

        <!-- ========== TOP NAVBAR ========== -->
        <?php include 'includes/topbar.php';?>
        <!-- ========== WRAPPER FOR BOTH SIDEBARS & MAIN CONTENT ========== -->
        <div class="content-wrapper">
            <div class="content-container">
                <?php include 'includes/leftbar.php';?>

                <div class="main-page">
                    <div class="container-fluid">
                        <div class="row page-title-div">
                            <div class="col-md-6">
                                <h2 class="title">Manage Students</h2>

                            </div>

                            <!-- /.col-md-6 text-right -->
                        </div>
                        <!-- /.row -->
                        <div class="row breadcrumb-div">
                            <div class="col-md-6">
                                <ul class="breadcrumb">
                                    <li><a href="dashboard.php"><i class="fa fa-home"></i> Home</a></li>
                                    <li> Students</li>
                                    <li class="active">Manage Students</li>
                                </ul>
                            </div>

                        </div>
                        <!-- /.row -->
                    </div>
                    <!-- /.container-fluid -->

                    <section class="section">
                        <div class="container-fluid" style="background:#fff">


<?php
$pdo = new PDO("mysql:host=localhost;dbname=srms;charset=utf8", "root", "");

// Récupérer tous les étudiants pour la liste déroulante
$students = $pdo->query("SELECT StudentId, StudentName, RollId FROM tblstudents ORDER BY StudentName")->fetchAll(PDO::FETCH_ASSOC);

$selectedId = isset($_GET['etudiant']) ? (int)$_GET['etudiant'] : 0;
$class = isset($_GET['class']) ? (int)$_GET['class'] : 1;
$studentInfo = [];
$subjectResults = [];

if ($selectedId > 0) {
    // Infos étudiant
    $stmt = $pdo->prepare("SELECT st.StudentId, st.StudentName, st.ClassId, st.RollId, cl.ClassName
        FROM tblstudents st
        JOIN tblclasses cl ON st.ClassId = cl.id
        WHERE st.StudentId = ?");
    $stmt->execute([$selectedId]);
    $studentInfo = $stmt->fetch(PDO::FETCH_ASSOC);

    // Résultats matières
    $sql = "
        SELECT DISTINCT sc.id, s.SubjectName, sc.credit, r.marks
        FROM tblresult r
        JOIN tblsubjects s ON r.SubjectId = s.id
        JOIN tblsubjectcombination sc ON sc.SubjectId = s.id AND sc.ClassId = ?
        WHERE r.StudentId = ?  AND sc.ProfessorId > 0
        ORDER BY s.SubjectName
    ";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$class, $selectedId]);
    $subjectResults = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // Calculs
    $totalPoints = 0;
    $totalCredits = 0;
    $creditsValid = 0;
    $creditsInvalid = 0;
    $failsLight = 0;
    $failsSerious = 0;

    foreach ($subjectResults as &$sub) {
        $note = (float)$sub['marks'];
        $credit = (float)$sub['credit'];
        $totalPoints += $note * $credit;
        $totalCredits += $credit;

        if ($note < 8) $failsSerious++;
        elseif ($note < 10) $failsLight++;

        if ($note >= 10) $creditsValid += $credit;
        else $creditsInvalid += $credit;

        $sub['valid'] = $note >= 10;
    }

    $average = $totalCredits > 0 ? $totalPoints / $totalCredits : 0;
    if ($average >= 16) $mention = "Très Bien";
    elseif ($average >= 14) $mention = "Bien";
    elseif ($average >= 12) $mention = "Assez Bien";
    elseif ($average >= 10) $mention = "Passable";
    else $mention = "Échec";
}
?>

    <style>
        body { font-family: Arial, sans-serif;  }
        h2 { color: #333; }
        .note-valid { color: green; font-weight: bold; }
        .note-invalid { color: red; font-weight: bold; }
        table { border-collapse: collapse; width: 100%; margin-top: 15px; }
        th, td { border: 1px solid #ccc; padding: 8px; text-align: left; }
        label, select { font-size: 16px; margin-bottom: 10px; display: block; }
        .info { margin-bottom: 20px; }
        .summary { margin-top: 20px; font-size: 15px; }
    </style>


<h2>Relevé de notes - Étudiant</h2>

<form method="get" style="display:none">
    <label for="etudiant">Choisir un étudiant :</label>
    <select name="etudiant" id="etudiant" onchange="this.form.submit()">
        <option value="">-- Sélectionner --</option>
        <?php foreach ($students as $st): ?>
            <option value="<?= $st['StudentId'] ?>" <?= $selectedId==$st['StudentId'] ? 'selected' : '' ?>>
                <?= htmlspecialchars($st['StudentName']) ?> (<?= $st['RollId'] ?>)
            </option>
        <?php endforeach; ?>
    </select>
</form>

<?php if ($selectedId && $studentInfo): ?>
    <div class="info">
        <strong>Nom :</strong> <?= htmlspecialchars($studentInfo['StudentName']) ?><br>
        <strong>Matricule :</strong> <?= htmlspecialchars($studentInfo['RollId']) ?><br>
        <strong>Classe :</strong> <?= htmlspecialchars($studentInfo['ClassName']) ?>
    </div>

    <button id="exportPDF">📄 Exporter en PDF</button>

    <table id="releveTable">
        <thead>
            <tr>
                <th>Matière</th>
                <th>Crédit</th>
                <th>Note</th>
                <th>Validation</th>
            </tr>
        </thead>
        <tbody>
		<?php //var_dump($subjectResults);?>
            <?php foreach($subjectResults as $subx): ?>
                <tr>
                    <td><?= htmlspecialchars($subx['SubjectName']) ?></td>
                    <td><?= $subx['credit'] ?></td>
                    <td class="<?= $subx['valid'] ? 'note-valid' : 'note-invalid' ?>">
                        <?= $subx['marks'] ?>
                    </td>
                    <td>
                        <?= $subx['valid'] ? '✅ Validé' : '❌ Non validé' ?>
                    </td>
                </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

    <div class="summary">
        <p><strong>Crédits validés :</strong> <?= $creditsValid ?></p>
        <p><strong>Crédits non validés :</strong> <?= $creditsInvalid ?></p>
        <p><strong>Échecs légers :</strong> <?= $failsLight ?> | <strong>Échecs graves :</strong> <?= $failsSerious ?></p>
        <p><strong>Moyenne :</strong> <?= number_format($average, 2) ?></p>
        <p><strong>Mention :</strong> <?= $mention ?></p>
    </div>
<?php endif; ?>

<!-- jsPDF -->
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf-autotable/3.5.29/jspdf.plugin.autotable.min.js"></script>
<script>
document.getElementById("exportPDF")?.addEventListener("click", function () {
    const { jsPDF } = window.jspdf;
    const doc = new jsPDF('p', 'pt', 'a4');

    doc.setFontSize(14);
    doc.text("Relevé de notes - Étudiant", 40, 40);

    // Infos
    let y = 60;
    <?php if ($studentInfo): ?>
    doc.setFontSize(11);
    doc.text("Nom : <?= addslashes($studentInfo['StudentName']) ?>", 40, y);
    doc.text("Matricule : <?= addslashes($studentInfo['RollId']) ?>", 40, y + 15);
    doc.text("Classe : <?= addslashes($studentInfo['ClassName']) ?>", 40, y + 30);
    y += 50;
    <?php endif; ?>

    // Tableau des notes
    doc.autoTable({
        html: '#releveTable',
        startY: y,
        theme: 'grid',
        headStyles: { fillColor: [230,230,230] },
        styles: { fontSize: 9, halign: 'center' },
        didParseCell: function (data) {
            if (data.cell.raw.classList.contains("note-valid")) {
                data.cell.styles.textColor = [0, 128, 0];
                data.cell.styles.fontStyle = 'bold';
            }
            if (data.cell.raw.classList.contains("note-invalid")) {
                data.cell.styles.textColor = [200, 0, 0];
                data.cell.styles.fontStyle = 'bold';
            }
        }
    });

    doc.save("releve_notes.pdf");
});
</script>
 </div>
                </div>
                <!-- /.panel -->
            </div>
            <!-- /.col-md-6 -->

        </div>
        <!-- /.row -->

    </div>
    <!-- /.container-fluid -->
    </section>
    <!-- /.section -->

    </div>
    <!-- /.main-page -->



    </div>
    <!-- /.content-container -->
    </div>
    <!-- /.content-wrapper -->

    </div>
    <!-- /.main-wrapper -->

    <!-- ========== COMMON JS FILES ========== -->
    <script src="js/jquery/jquery-2.2.4.min.js"></script>
    <script src="js/bootstrap/bootstrap.min.js"></script>
    <script src="js/pace/pace.min.js"></script>
    <script src="js/lobipanel/lobipanel.min.js"></script>
    <script src="js/iscroll/iscroll.js"></script>

    <!-- ========== PAGE JS FILES ========== -->
    <script src="js/prism/prism.js"></script>
    <script src="js/DataTables/datatables.min.js"></script>

    <!-- ========== THEME JS ========== -->
    <script src="js/main.js"></script>
    <script>
        $(function ($) {
            $('#example').DataTable();

            $('#example2').DataTable({
                "scrollY": "300px",
                "scrollCollapse": true,
                "paging": false
            });

            $('#example3').DataTable();
        });
    </script>
</body>

</html>
<?php }?>