<?php
// Connexion DB
include "includes/configpdo.php";
$conn = $mysqli;
if ($conn->connect_error) die("Erreur connexion : " . $conn->connect_error);

// Récupérer studentId
$studentId = isset($_GET['studentId']) ? intval($_GET['studentId']) : 0;
if (!$studentId) die("❌ Aucun étudiant sélectionné");

// Infos étudiant
$sqlStudent = "SELECT s.StudentName, s.RollId, c.ClassName
               FROM tblstudents s
               JOIN tblclasses c ON s.ClassId = c.id
               WHERE s.StudentId = ?";
$stmt = $conn->prepare($sqlStudent);
$stmt->bind_param("i", $studentId);
$stmt->execute();
$resStudent = $stmt->get_result()->fetch_assoc();
$stmt->close();

if (!$resStudent) die("❌ Étudiant introuvable");

// Résultats + crédits
$sqlResults = "SELECT sub.SubjectName, r.marks, sc.credit
               FROM tblresult r
               JOIN tblsubjects sub ON sub.id = r.SubjectId
               JOIN tblsubjectcombination sc ON sc.SubjectId = sub.id AND sc.ClassId = r.ClassId
               WHERE r.StudentId = ? AND sc.ProfessorId > 0";
$stmt = $conn->prepare($sqlResults);
$stmt->bind_param("i", $studentId);
$stmt->execute();
$res = $stmt->get_result();

$results = [];
$totalMarks = 0; $count = 0; $creditsValid = 0; $creditsInvalid = 0;

while ($row = $res->fetch_assoc()) {
    $results[] = $row;
    $totalMarks += $row['marks'];
    $count++;
    if ($row['marks'] >= 10) $creditsValid += $row['credit'];
    else $creditsInvalid += $row['credit'];
}
$stmt->close();

$average = $count > 0 ? round($totalMarks / $count, 2) : 0;

// Mention selon règles LMD
if ($average >= 16) $mention = "Très Bien";
elseif ($average >= 14) $mention = "Bien";
elseif ($average >= 12) $mention = "Assez Bien";
elseif ($average >= 10) $mention = "Passable";
else $mention = "Échec";

// Générer QR code en ligne (plus tard tu peux utiliser endroid/qr-code)
$qrDataUri = "https://api.qrserver.com/v1/create-qr-code/?size=120x120&data=https://tonsite.com/releve.php?studentId=" . $studentId;

?>
<!DOCTYPE html>
<html lang="fr">
<head>
<meta charset="UTF-8">
<title>Relevé des Notes</title>
<style>
  body { font-family: "Segoe UI", Tahoma, sans-serif; background: #f8fafc; padding:40px; }
  .transcript { background: white; padding: 30px; border-radius: 12px; box-shadow: 0 4px 20px rgba(0,0,0,0.1); width: 800px; margin:auto; }
  .header { text-align: center; margin-bottom: 25px; }
  .header img { height: 60px; }
  .header h2 { margin: 5px 0; color: #0f172a; }
  .header h3 { margin: 0; font-weight: normal; color:#334155; }
  .meta { text-align: center; font-size: 14px; color: #475569; margin-bottom: 20px; }
  table { width: 100%; border-collapse: collapse; margin-bottom: 20px; }
  th, td { border: 1px solid #cbd5e1; padding: 10px; text-align: left; }
  th { background: #f1f5f9; font-weight: 600; }
  td.pass { color: #065f46; font-weight: 600; }
  td.fail { color: #991b1b; font-weight: 600; }
  .summary { margin-top: 20px; font-size: 15px; }
  .summary strong { color: #0f172a; }
  .footer { margin-top: 40px; display:flex; justify-content: space-between; align-items: center; }
  .footer .sign { text-align:left; }
  .footer .qr { text-align:right; }
  .footer .qr p { font-size:12px; color:#6b7280; margin:0; }
  button { margin-top: 20px; padding: 10px 20px; border: none; background: #0f172a; color: white; font-size: 15px; border-radius: 8px; cursor: pointer; }
</style>
</head>
<body>

<div class="transcript" id="transcript">
  <div class="header">
    <img src="logo_unikin.png" alt="Logo Université">
    <h2>Université de Kinshasa</h2>
    <h3>Relevé des Notes Officiel</h3>
  </div>
  <div class="meta">
    <div><strong>Nom :</strong> <?= $resStudent["StudentName"] ?></div>
    <div><strong>Matricule :</strong> <?= $resStudent["RollId"] ?></div>
    <div><strong>Classe :</strong> <?= $resStudent["ClassName"] ?></div>
  </div>

  <table>
    <tr>
      <th>Matière</th>
      <th>Note /20</th>
      <th>Crédits</th>
      <th>Validation</th>
    </tr>
    <?php foreach ($results as $row): ?>
    <tr>
      <td><?= $row["SubjectName"] ?></td>
      <td class="<?= ($row['marks'] >= 10 ? 'pass' : 'fail') ?>">
        <?= $row["marks"] ?>
      </td>
      <td><?= $row["credit"] ?></td>
      <td><?= ($row["marks"] >= 10 ? "Validé" : "Échec") ?></td>
    </tr>
    <?php endforeach; ?>
  </table>

  <div class="summary">
    <p><strong>Moyenne :</strong> <?= $average ?>/20</p>
    <p><strong>Crédits validés :</strong> <?= $creditsValid ?></p>
    <p><strong>Crédits non validés :</strong> <?= $creditsInvalid ?></p>
    <p><strong>Mention :</strong> <?= $mention ?></p>
  </div>

  <div class="footer">
    <div class="sign">
      <p>Fait à Kinshasa, le <?= date("d/m/Y") ?></p>
      <p><strong>Le Doyen</strong></p><br><br>
      <p>_____________________</p>
    </div>
    <div class="qr">
      <img src="<?= $qrDataUri ?>" alt="QR Code">
      <p>Vérifiez en ligne</p>
    </div>
  </div>

  <button id="btnExport">📥 Télécharger en PDF</button>
</div>

<script src="https://cdnjs.cloudflare.com/ajax/libs/html2pdf.js/0.10.1/html2pdf.bundle.min.js"></script>
<script>
document.getElementById("btnExport").addEventListener("click", function() {
    const element = document.getElementById("transcript");
    const opt = {
        margin:       0.1,
        filename:     "releve-notes-<?= $resStudent['StudentName'] ?>.pdf",
        image:        { type: 'jpeg', quality: 1 },
        html2canvas:  { scale: 2, useCORS: true },
        jsPDF:        { unit: 'in', format: 'A4', orientation: 'portrait' }
    };
    html2pdf().set(opt).from(element).save();
});
</script>

</body>
</html>
